<?php
    session_start();
    include('../includes/header.php');
    include('../includes/navigation.php');
    include $_SERVER['DOCUMENT_ROOT'] . '/MailChimpMarketing/Models/Campaigns.php';

    $results = new Campaigns();
    $campaigns = $results->getIndex();
?>
  <!-- Main Sidebar Container -->
 
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Campaigns</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Campaigns</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
    <?php
        if(isset($_SESSION['error'])){
          echo "
            <div class='alert alert-danger alert-dismissible'>
              <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
              <h4><i class='icon fa fa-warning'></i> Error!</h4>
              ".$_SESSION['error']."
            </div>
          ";
          unset($_SESSION['error']);
        }
        if(isset($_SESSION['success'])){
          echo "
            <div class='alert alert-success alert-dismissible'>
              <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
              <h4><i class='icon fa fa-check'></i> Success!</h4>
              ".$_SESSION['success']."
            </div>
          ";
          unset($_SESSION['success']);
        }
      ?>
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <!-- /.card -->
            <div class="card">
              <div class="card-header">
                  <a href="add.php" class="btn btn-primary btn-sm btn-flat"><i class="fa fa-plus"></i> Create Campaign</a>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Name</th>
                    <th>Total Sent</th>
                    <th>Date/Time Sent</th>
                    <th>Status</th>
                    <th>Action</th>
                  </tr>
                  </thead>
                  <tbody>
                    <?php
                        foreach($campaigns->campaigns as $campaign){ 
                            $status = ($campaign->status == 'sent') ? 'badge bg-success' : 'badge badge-danger';
                            $date = date('d D Y H:i:s' , strtotime($campaign->send_time));
                            $id = $campaign->id;
                        ?>
                        <tr>
                            <td><?php echo $campaign->settings->title; ?></td>
                            <td><?php echo $campaign->emails_sent;; ?></td>
                            <td><?php echo $date;; ?></td>
                            <td><span class="<?php echo $status;?> "><?php echo $campaign->status; ?></span></td>
                            <td>
                            <a href="schedule.php?id=<?php echo $campaign->id; ?>" class='btn btn-info btn-sm btn-flat'><i class='fa fa-search'></i> Schedule</a>
                            </td>
                            
                        </tr>
                <?php } ?>
                  </tbody>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <?php include('../includes/script.php'); ?>
  <script>
  $(function () {
    $("#example1").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
  });
</script>
  <?php include('../includes/footer.php'); ?>